
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.lang;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.languages.CompletionItem;

public class MercuryCompletionItem extends CompletionItem implements Cloneable
{
	private String text;
	private String library;
	private String filePath;
	private int    declOffset;
	private int    srcOffset;

	public static MercuryCompletionItem create (String text)
	{
		return (new MercuryCompletionItem(text, null, null, null, 200));
	}

	public static MercuryCompletionItem create (String text, String description, String library,
												CompletionItem.Type type, int priority)
	{
		return (new MercuryCompletionItem(text, description, library, type, priority));
	}

	public static MercuryCompletionItem create (String text, String description, String library,
												CompletionItem.Type type, int priority,
												String filePath, int declOffset, int srcOffset)
	{
		return (new MercuryCompletionItem(text, description, library, type, priority,
											filePath, declOffset, srcOffset));
	}

	public static List<MercuryCompletionItem> fromList (List<CompletionItem> items)
	{
		//return ((List<MercuryCompletionItem>)(List<?>) items);

		if (items == null)
			return null;

		List<MercuryCompletionItem> mitems = new ArrayList<MercuryCompletionItem>();
		Iterator<CompletionItem> it = items.iterator();
		while (it.hasNext())
			mitems.add(new MercuryCompletionItem(it.next()));

		return mitems;
	}

	public MercuryCompletionItem (String text, String description, String library,
									CompletionItem.Type type, int priority)
	{
		super(text, description, library, type, priority);
		this.text = text;
		this.library = library;
	}

	public MercuryCompletionItem (String text, String description, String library,
									CompletionItem.Type type, int priority,
									String filePath, int declOffset, int srcOffset)
	{
		this(text, description, library, type, priority);
		this.filePath = filePath;
		this.declOffset = declOffset;
		this.srcOffset = srcOffset;
	}

	public MercuryCompletionItem (CompletionItem item)
	{
		this(item.getText(), item.getDescription(), item.getLibrary(),
				item.getType(), item.getPriority());
	}

	@Override
	protected Object clone () throws CloneNotSupportedException
	{
		return super.clone();
	}

	public MercuryCompletionItem cloneItem ()
	{
		try
		{
			return ((MercuryCompletionItem) this.clone());
		}
		catch (CloneNotSupportedException ex) { }

		return null;
	}

	@Override
	public String getText ()
	{
		return this.text;
	}

	public MercuryCompletionItem setText (String text)
	{
		this.text = text;
		return this;
	}

	@Override
	public String getDescription ()
	{
		return super.getDescription();
	}

	@Override
	public String getLibrary ()
	{
		return this.library;
	}

	public MercuryCompletionItem setLibrary (String library)
	{
		this.library = library;
		return this;
	}

	@Override
	public CompletionItem.Type getType ()
	{
		return super.getType();
	}

	@Override
	public int getPriority ()
	{
		return super.getPriority();
	}

	public String getFilePath ()
	{
		return this.filePath;
	}

	public int getDeclOffset ()
	{
		return this.declOffset;
	}

	public MercuryCompletionItem setDeclOffset (int offset)
	{
		this.declOffset = offset;
		return this;
	}

	public int getSrcOffset ()
	{
		return this.srcOffset;
	}

	public MercuryCompletionItem setSrcOffset (int offset)
	{
		this.srcOffset = offset;
		return this;
	}

	public int getOffset ()
	{
		return ((this.srcOffset > 0) ? this.srcOffset : this.declOffset);
	}
}
