
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.gui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class MainOptionsPanelController extends OptionsPanelController
{
	private MainOptionsPanel panel;
	private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
	private boolean changed;

	public void update ()
	{
		getPanel().load();
		changed = false;
	}

	public void applyChanges ()
	{
		getPanel().store();
		changed = false;
	}

	public void cancel ()
	{
		getPanel().reset();
		changed = false;
	}

	public boolean isValid ()
	{
		return getPanel().valid();
	}

	public boolean isChanged ()
	{
		return changed;
	}

	public HelpCtx getHelpCtx ()
	{
		return null; // new HelpCtx("...ID") if you have a help set
	}

	public JComponent getComponent (Lookup masterLookup)
	{
		return getPanel();
	}

	public void addPropertyChangeListener (PropertyChangeListener l)
	{
		pcs.addPropertyChangeListener(l);
	}

	public void removePropertyChangeListener (PropertyChangeListener l)
	{
		if (l != null)
			pcs.removePropertyChangeListener(l);
		else
		{
			final PropertyChangeListener[] ls = pcs.getPropertyChangeListeners();
			//for (int i = 0; i < ls.length; i++)
			for (PropertyChangeListener l1 : ls)
				pcs.removePropertyChangeListener(l1);
		}
	}

	private MainOptionsPanel getPanel ()
	{
		if (panel == null)
			panel = new MainOptionsPanel(this);

		return panel;
	}

	void changed ()
	{
		if (!changed)
		{
			changed = true;
			pcs.firePropertyChange(OptionsPanelController.PROP_CHANGED, false, true);
		}

		pcs.firePropertyChange(OptionsPanelController.PROP_VALID, null, null);
	}

	// -----------------------------------------------------------------

	public void setChanged (boolean changed)
	{
		this.changed = changed;
	}
}
