
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultEditorKit;
import org.mercury.compiler.CompilerHelper;
import org.mercury.global.MercuryInterface;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

//final class MainOptionsPanel extends javax.swing.JPanel
public final class MainOptionsPanel extends javax.swing.JPanel
										implements DocumentListener, ItemListener, ActionListener
{
	// XXX TODO may be move this defines to CompilerHelper?
	public static final String MERCURY_BIN_SUBDIR  = "bin";
	public static final String MERCURY_LIB_SUBDIR  = "lib" + File.separator + "mercury";
	public static final String MERCURY_INTS_SUBDIR = MERCURY_LIB_SUBDIR  + File.separator + "ints";

	public static final String MERCURY_MMC_NIX_CMD     = "mmc --make"; // --output-compile-error-lines
	public static final String MERCURY_MMC_WIN_CMD     = "mercury.bat --make";
	public static final String MERCURY_MMC_MINGW_CMD   = "sh mmc --make";
	public static final String MERCURY_MMAKE_NIX_CMD   = "mmake --use-mmc-make"; // why --use-mmc-make ???
	public static final String MERCURY_MMAKE_WIN_CMD   = "";
	public static final String MERCURY_MMAKE_MINGW_CMD = "sh mmake --use-mmc-make";

	public static final String MERCURY_MMC_DEFAULT_CMD = Utilities.isWindows() ?
			MainOptionsPanel.MERCURY_MMC_WIN_CMD : MainOptionsPanel.MERCURY_MMC_NIX_CMD;
	public static final String MERCURY_MMAKE_DEFAULT_CMD = Utilities.isWindows() ?
			MainOptionsPanel.MERCURY_MMAKE_WIN_CMD : MainOptionsPanel.MERCURY_MMAKE_NIX_CMD;

	private static volatile String   mercuryPath;       // mercury install path
	private static volatile String   mercuryCompiler;   // compiler cmd with args
	private static volatile boolean  mercuryCompilerOverride;
	private static volatile String   mercuryMake;       // mmake cmd with args
	private static volatile boolean  mercuryMakeOverride;
	private static volatile String   additionalExecute; // additional cmd or file to exec before other commands
	private static volatile String   binsPath;          // additional binary paths

	private static volatile String   mercuryBinPath;  // mercury bin path (generated after gui update)
	private static volatile String   mercuryLibPath;  // mercury lib path (generated after gui update)

	private static volatile boolean  prefsUpdated = true;

	private final MainOptionsPanelController controller;
	//private final Preferences prefs;
	private final Object updateLock = new Object();
	private volatile boolean waitUpdate = false;

	MainOptionsPanel (MainOptionsPanelController controller)
	{
		this.controller = controller;
		//this.prefs = NbPreferences.forModule(MainOptionsPanel.class);

		initComponents();

		jTextFieldMercuryPath.getDocument().addDocumentListener(this);
		jTextFieldMercuryCompiler.getDocument().addDocumentListener(this);
		jTextFieldMercuryMake.getDocument().addDocumentListener(this);
		jTextFieldAdditionalExecute.getDocument().addDocumentListener(this);
		jTextFieldBinsPath.getDocument().addDocumentListener(this);

		jCheckBoxMercuryCompiler.addItemListener(this);
		jCheckBoxMercuryMake.addItemListener(this);

		jButtonMercuryPath.addActionListener(this);
		jButtonAdditionalExecute.addActionListener(this);

		addPopupMenu(jTextFieldMercuryPath);
		addPopupMenu(jTextFieldMercuryCompiler);
		addPopupMenu(jTextFieldMercuryMake);
		addPopupMenu(jTextFieldAdditionalExecute);
		addPopupMenu(jTextFieldBinsPath);
	}

	public static void addPopupMenu (JTextField jTextField)
	{
		JPopupMenu popup = new JPopupMenu(); // may be create single menu for all fields?

		// XXX TODO fix "copy-to-clipboard", "select-all", ...
		//Action copyAction = jTextField.getActionMap().get(DefaultEditorKit.copyAction);
		//Action cutAction = jTextField.getActionMap().get(DefaultEditorKit.cutAction);
		//Action pasteAction = jTextField.getActionMap().get(DefaultEditorKit.pasteAction);
		Action undoAction = null;//jTextField.getActionMap().get("undo");
		Action selectAllAction = jTextField.getActionMap().get(DefaultEditorKit.selectAllAction);

		// XXX TODO move "Copy", "Cut", "Paste" to properties file or get localization from NetBeans
		JMenuItem copyAction = new JMenuItem(new DefaultEditorKit.CopyAction());
		copyAction.setText("Copy");
		JMenuItem cutAction = new JMenuItem(new DefaultEditorKit.CutAction());
		cutAction.setText("Cut");
		JMenuItem pasteAction = new JMenuItem(new DefaultEditorKit.PasteAction());
		pasteAction.setText("Paste");

		if (undoAction != null)
		{
			popup.add(undoAction);
			popup.addSeparator();
		}
		if (cutAction != null)
			popup.add(cutAction);
		if (copyAction != null)
			popup.add(copyAction);
		if (pasteAction != null)
			popup.add(pasteAction);
		if (selectAllAction != null)
		{
			popup.addSeparator();
			popup.add(selectAllAction);
		}

		jTextField.setComponentPopupMenu(popup);
	}

	public static void disableButton (Container c,
											String iconName, String nameContains)
	{
		int len = c.getComponentCount();
		for (int i = 0; i < len; i++)
		{
			Component comp = c.getComponent(i);
			if (comp instanceof JButton)
			{
				final JButton b = (JButton) comp;
				final Icon icon = b.getIcon();
				final String name = b.getName();
				if ((icon != null && iconName != null && icon == UIManager.getIcon(iconName)) ||
						(name != null && nameContains != null &&
							name.toLowerCase().indexOf(nameContains.toLowerCase()) != -1))
				{
					b.setEnabled(false);
				}
			}
			else if (comp instanceof Container)
				disableButton((Container) comp, iconName, nameContains);
		}
	}

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelMercuryCompiler = new javax.swing.JLabel();
        jTextFieldMercuryCompiler = new javax.swing.JTextField();
        jLabelMercuryCompilerHint1 = new javax.swing.JLabel();
        jLabelMercuryCompilerHint2 = new javax.swing.JLabel();
        jCheckBoxMercuryCompiler = new javax.swing.JCheckBox();
        jLabelMercuryMake = new javax.swing.JLabel();
        jTextFieldMercuryMake = new javax.swing.JTextField();
        jLabelMercuryMakeHint1 = new javax.swing.JLabel();
        jLabelMercuryMakeHint2 = new javax.swing.JLabel();
        jCheckBoxMercuryMake = new javax.swing.JCheckBox();
        jLabelBinsPath = new javax.swing.JLabel();
        jTextFieldBinsPath = new javax.swing.JTextField();
        jLabelBinsPathHint1 = new javax.swing.JLabel();
        jLabelMercuryPath = new javax.swing.JLabel();
        jTextFieldMercuryPath = new javax.swing.JTextField();
        jLabelMercuryPathHint2 = new javax.swing.JLabel();
        jLabelMercuryPathHint1 = new javax.swing.JLabel();
        jButtonMercuryPath = new javax.swing.JButton();
        jLabelAdditionalExecute = new javax.swing.JLabel();
        jTextFieldAdditionalExecute = new javax.swing.JTextField();
        jLabelAdditionalExecuteHint1 = new javax.swing.JLabel();
        jButtonAdditionalExecute = new javax.swing.JButton();

        jLabelMercuryCompiler.setFont(jLabelMercuryCompiler.getFont().deriveFont(jLabelMercuryCompiler.getFont().getSize()+1f));
        jLabelMercuryCompiler.setLabelFor(jTextFieldMercuryCompiler);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelMercuryCompiler, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelMercuryCompiler.text")); // NOI18N
        jLabelMercuryCompiler.setFocusable(false);

        jTextFieldMercuryCompiler.setFont(jTextFieldMercuryCompiler.getFont());
        jTextFieldMercuryCompiler.setText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldMercuryCompiler.text")); // NOI18N
        jTextFieldMercuryCompiler.setToolTipText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldMercuryCompiler.toolTipText")); // NOI18N

        jLabelMercuryCompilerHint1.setFont(jLabelMercuryCompilerHint1.getFont().deriveFont(jLabelMercuryCompilerHint1.getFont().getSize()-1f));
        jLabelMercuryCompilerHint1.setLabelFor(jTextFieldMercuryCompiler);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelMercuryCompilerHint1, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelMercuryCompilerHint1.text")); // NOI18N
        jLabelMercuryCompilerHint1.setFocusable(false);

        jLabelMercuryCompilerHint2.setFont(jLabelMercuryCompilerHint2.getFont().deriveFont(jLabelMercuryCompilerHint2.getFont().getSize()-1f));
        jLabelMercuryCompilerHint2.setLabelFor(jTextFieldMercuryCompiler);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelMercuryCompilerHint2, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelMercuryCompilerHint2.text")); // NOI18N
        jLabelMercuryCompilerHint2.setFocusable(false);

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxMercuryCompiler, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jCheckBoxMercuryCompiler.text")); // NOI18N

        jLabelMercuryMake.setFont(jLabelMercuryMake.getFont().deriveFont(jLabelMercuryMake.getFont().getSize()+1f));
        jLabelMercuryMake.setLabelFor(jTextFieldMercuryMake);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelMercuryMake, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelMercuryMake.text")); // NOI18N
        jLabelMercuryMake.setFocusable(false);

        jTextFieldMercuryMake.setFont(jTextFieldMercuryMake.getFont());
        jTextFieldMercuryMake.setText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldMercuryMake.text")); // NOI18N
        jTextFieldMercuryMake.setToolTipText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldMercuryMake.toolTipText")); // NOI18N

        jLabelMercuryMakeHint1.setFont(jLabelMercuryMakeHint1.getFont().deriveFont(jLabelMercuryMakeHint1.getFont().getSize()-1f));
        jLabelMercuryMakeHint1.setLabelFor(jTextFieldMercuryMake);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelMercuryMakeHint1, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelMercuryMakeHint1.text")); // NOI18N
        jLabelMercuryMakeHint1.setFocusable(false);

        jLabelMercuryMakeHint2.setFont(jLabelMercuryMakeHint2.getFont().deriveFont(jLabelMercuryMakeHint2.getFont().getSize()-1f));
        jLabelMercuryMakeHint2.setLabelFor(jTextFieldMercuryMake);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelMercuryMakeHint2, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelMercuryMakeHint2.text")); // NOI18N
        jLabelMercuryMakeHint2.setFocusable(false);

        org.openide.awt.Mnemonics.setLocalizedText(jCheckBoxMercuryMake, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jCheckBoxMercuryMake.text")); // NOI18N

        jLabelBinsPath.setFont(jLabelBinsPath.getFont().deriveFont(jLabelBinsPath.getFont().getSize()+1f));
        jLabelBinsPath.setLabelFor(jTextFieldBinsPath);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelBinsPath, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelBinsPath.text")); // NOI18N
        jLabelBinsPath.setFocusable(false);

        jTextFieldBinsPath.setFont(jTextFieldBinsPath.getFont());
        jTextFieldBinsPath.setText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldBinsPath.text")); // NOI18N
        jTextFieldBinsPath.setToolTipText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldBinsPath.toolTipText")); // NOI18N

        jLabelBinsPathHint1.setFont(jLabelBinsPathHint1.getFont().deriveFont(jLabelBinsPathHint1.getFont().getSize()-1f));
        jLabelBinsPathHint1.setLabelFor(jTextFieldBinsPath);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelBinsPathHint1, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelBinsPathHint1.text")); // NOI18N
        jLabelBinsPathHint1.setFocusable(false);

        jLabelMercuryPath.setFont(jLabelMercuryPath.getFont().deriveFont(jLabelMercuryPath.getFont().getSize()+1f));
        jLabelMercuryPath.setLabelFor(jTextFieldMercuryPath);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelMercuryPath, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelMercuryPath.text")); // NOI18N
        jLabelMercuryPath.setFocusable(false);

        jTextFieldMercuryPath.setFont(jTextFieldMercuryPath.getFont());
        jTextFieldMercuryPath.setText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldMercuryPath.text")); // NOI18N
        jTextFieldMercuryPath.setToolTipText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldMercuryPath.toolTipText")); // NOI18N

        jLabelMercuryPathHint2.setFont(jLabelMercuryPathHint2.getFont().deriveFont(jLabelMercuryPathHint2.getFont().getSize()-1f));
        jLabelMercuryPathHint2.setLabelFor(jTextFieldMercuryPath);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelMercuryPathHint2, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelMercuryPathHint2.text")); // NOI18N
        jLabelMercuryPathHint2.setFocusable(false);

        jLabelMercuryPathHint1.setFont(jLabelMercuryPathHint1.getFont().deriveFont(jLabelMercuryPathHint1.getFont().getSize()-1f));
        jLabelMercuryPathHint1.setLabelFor(jTextFieldMercuryPath);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelMercuryPathHint1, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelMercuryPathHint1.text")); // NOI18N
        jLabelMercuryPathHint1.setFocusable(false);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonMercuryPath, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jButtonMercuryPath.text")); // NOI18N
        jButtonMercuryPath.setActionCommand(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jButtonMercuryPath.actionCommand")); // NOI18N

        jLabelAdditionalExecute.setFont(jLabelAdditionalExecute.getFont().deriveFont(jLabelAdditionalExecute.getFont().getSize()+1f));
        jLabelAdditionalExecute.setLabelFor(jTextFieldAdditionalExecute);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelAdditionalExecute, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelAdditionalExecute.text")); // NOI18N
        jLabelAdditionalExecute.setFocusable(false);

        jTextFieldAdditionalExecute.setFont(jTextFieldAdditionalExecute.getFont());
        jTextFieldAdditionalExecute.setText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldAdditionalExecute.text")); // NOI18N
        jTextFieldAdditionalExecute.setToolTipText(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jTextFieldAdditionalExecute.toolTipText")); // NOI18N

        jLabelAdditionalExecuteHint1.setFont(jLabelAdditionalExecuteHint1.getFont().deriveFont(jLabelAdditionalExecuteHint1.getFont().getSize()-1f));
        jLabelAdditionalExecuteHint1.setLabelFor(jTextFieldAdditionalExecute);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelAdditionalExecuteHint1, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jLabelAdditionalExecuteHint1.text")); // NOI18N
        jLabelAdditionalExecuteHint1.setFocusable(false);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonAdditionalExecute, org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jButtonAdditionalExecute.text")); // NOI18N
        jButtonAdditionalExecute.setActionCommand(org.openide.util.NbBundle.getMessage(MainOptionsPanel.class, "MainOptionsPanel.jButtonAdditionalExecute.actionCommand")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelMercuryPath, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabelMercuryMake, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabelMercuryCompiler, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabelBinsPath, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabelAdditionalExecute, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(32, 32, 32)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabelMercuryPathHint2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(jTextFieldMercuryPath)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonMercuryPath))
                            .addComponent(jLabelMercuryPathHint1, javax.swing.GroupLayout.DEFAULT_SIZE, 640, Short.MAX_VALUE)
                            .addComponent(jLabelMercuryCompilerHint2, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(jTextFieldMercuryCompiler)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jCheckBoxMercuryCompiler))
                            .addComponent(jLabelMercuryCompilerHint1, javax.swing.GroupLayout.DEFAULT_SIZE, 640, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(jLabelMercuryMakeHint1)
                                .addGap(323, 323, 323))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(jTextFieldMercuryMake)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jCheckBoxMercuryMake))
                            .addComponent(jLabelMercuryMakeHint2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(jTextFieldAdditionalExecute)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonAdditionalExecute))
                            .addComponent(jLabelAdditionalExecuteHint1, javax.swing.GroupLayout.DEFAULT_SIZE, 640, Short.MAX_VALUE)
                            .addComponent(jTextFieldBinsPath, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabelBinsPathHint1, javax.swing.GroupLayout.Alignment.TRAILING))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabelMercuryPath)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldMercuryPath, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonMercuryPath))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelMercuryPathHint1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelMercuryPathHint2)
                .addGap(18, 18, 18)
                .addComponent(jLabelMercuryCompiler)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldMercuryCompiler, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCheckBoxMercuryCompiler))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelMercuryCompilerHint1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelMercuryCompilerHint2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabelMercuryMake)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldMercuryMake, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCheckBoxMercuryMake))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelMercuryMakeHint1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelMercuryMakeHint2)
                .addGap(18, 18, 18)
                .addComponent(jLabelAdditionalExecute)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldAdditionalExecute, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonAdditionalExecute))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelAdditionalExecuteHint1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabelBinsPath)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldBinsPath, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelBinsPathHint1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAdditionalExecute;
    private javax.swing.JButton jButtonMercuryPath;
    private javax.swing.JCheckBox jCheckBoxMercuryCompiler;
    private javax.swing.JCheckBox jCheckBoxMercuryMake;
    private javax.swing.JLabel jLabelAdditionalExecute;
    private javax.swing.JLabel jLabelAdditionalExecuteHint1;
    private javax.swing.JLabel jLabelBinsPath;
    private javax.swing.JLabel jLabelBinsPathHint1;
    private javax.swing.JLabel jLabelMercuryCompiler;
    private javax.swing.JLabel jLabelMercuryCompilerHint1;
    private javax.swing.JLabel jLabelMercuryCompilerHint2;
    private javax.swing.JLabel jLabelMercuryMake;
    private javax.swing.JLabel jLabelMercuryMakeHint1;
    private javax.swing.JLabel jLabelMercuryMakeHint2;
    private javax.swing.JLabel jLabelMercuryPath;
    private javax.swing.JLabel jLabelMercuryPathHint1;
    private javax.swing.JLabel jLabelMercuryPathHint2;
    private javax.swing.JTextField jTextFieldAdditionalExecute;
    private javax.swing.JTextField jTextFieldBinsPath;
    private javax.swing.JTextField jTextFieldMercuryCompiler;
    private javax.swing.JTextField jTextFieldMercuryMake;
    private javax.swing.JTextField jTextFieldMercuryPath;
    // End of variables declaration//GEN-END:variables

	public void load ()
	{
		// load settings

		//MainOptionsPanel.prefsUpdated = true;
		updateSettings();

		updateElements(false); // change values at panel
		enableElements();

		// callbacks

		controller.addPropertyChangeListener(new PropertyChangeListener ()
			{
				public void propertyChange (PropertyChangeEvent pce)
				{
					updateElements(true); // get values from panel
					enableElements();

					setElementsDefaults();
				}
			});
	}

	public void store ()
	{
		// store all changes

		// remove listeners to avoid bug when .getText() return '' on close
		controller.removePropertyChangeListener(null);

		updatePrefs(true); // save

		MainOptionsPanel.prefsUpdated = true;
		updateSettings();

		// check mercury install path and compiler settings
		// XXX TODO may be check before save?
		checkSettings();
	}

	public void reset ()
	{
		// discard all changes

		controller.removePropertyChangeListener(null);

		MainOptionsPanel.prefsUpdated = true;
		updateSettings();
	}

	public boolean valid ()
	{
		// check whether form data is consistent and complete

		controller.setChanged(false); // XXX TODO disables 'Apply' button
		return true;
	}

	// DocumentListener interface (for textedits)

	public void changedUpdate (DocumentEvent e)
	{
		controller.changed();
	}

	public void removeUpdate (DocumentEvent e)
	{
		controller.changed();
	}

	public void insertUpdate (DocumentEvent e)
	{
		controller.changed();
	}

	// ItemListener interface (for checkboxes)

	public void itemStateChanged (ItemEvent e)
	{
		//Object source = e.getItemSelectable();
		//if (source == chinButton) {

		controller.changed();
	}

	// ActionListener interface (for buttons)

	public void actionPerformed (ActionEvent e)
	{
		// BrowseInstallPath
		// BrowseAdditionalExecutable
		final String action = e.getActionCommand();

		// XXX TODO move this code to separate func

		final boolean browsePath = "BrowseInstallPath".equals(action);
		final String title = browsePath ? // XXX TODO move to properties file
				"Select mercury install path" : "Select additional executable";

		JFileChooser chooser = new JFileChooser(".");
		//chooser.setCurrentDirectory(new java.io.File("."));
		chooser.setDialogTitle(title);
		chooser.setFileSelectionMode(browsePath ?
				JFileChooser.DIRECTORIES_ONLY : JFileChooser.FILES_ONLY);
		chooser.setAcceptAllFileFilterUsed(!browsePath);
		chooser.setMultiSelectionEnabled(false);
		disableButton(chooser, null/*"FileChooser.newFolderIcon"*/, "new");
		disableButton(chooser, null, "delete");
		disableButton(chooser, null, "rename");

		if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
		{
			synchronized (updateLock)
			{
				//final String path = chooser.getCurrentDirectory().getAbsolutePath();
				final String path = chooser.getSelectedFile().getAbsolutePath();
				if (browsePath)
					MainOptionsPanel.mercuryPath = path;
				else
					MainOptionsPanel.additionalExecute = path;
				updateElementsLater();
			}
		}
	}

	// -----------------------------------------------------------------

	// update panel elements or get values
	private void updateElements (boolean fromPanel)
	{
		synchronized (updateLock) {

		// Example:
		// someCheckBox.setSelected(Preferences.userNodeForPackage(MainOptionsPanel.class).getBoolean("someFlag",jTextFieldMercuryMakenide.util with API spec. version >= 7.4:
		// someCheckBox.setSelected(NbPreferences.forModule(MainOptionsPanel.class).getBoolean("someFlag", false));
		// or:
		// someTextField.setText(SomeSystemOption.getDefault().getSomeStringProperty());

		if (fromPanel)
		{
			if (waitUpdate)
				// XXX TODO we can't wait in AWT EDT because 'setText' uses EDT, so simple exit
				return;

			// get values from panel controls
			MainOptionsPanel.mercuryPath       = jTextFieldMercuryPath.getText().trim();
			MainOptionsPanel.mercuryCompiler   = jTextFieldMercuryCompiler.getText().trim();
			MainOptionsPanel.mercuryMake       = jTextFieldMercuryMake.getText().trim();
			MainOptionsPanel.additionalExecute = jTextFieldAdditionalExecute.getText().trim();
			MainOptionsPanel.binsPath          = jTextFieldBinsPath.getText().trim();

			MainOptionsPanel.mercuryCompilerOverride = jCheckBoxMercuryCompiler.isSelected();
			MainOptionsPanel.mercuryMakeOverride     = jCheckBoxMercuryMake.isSelected();
		}
		else
		{
			// set values in panel controls
			jTextFieldMercuryPath.setText(      MainOptionsPanel.mercuryPath);
			jTextFieldMercuryCompiler.setText(  MainOptionsPanel.mercuryCompiler);
			jTextFieldMercuryMake.setText(      MainOptionsPanel.mercuryMake);
			jTextFieldAdditionalExecute.setText(MainOptionsPanel.additionalExecute);
			jTextFieldBinsPath.setText(         MainOptionsPanel.binsPath);

			jCheckBoxMercuryCompiler.setSelected(MainOptionsPanel.mercuryCompilerOverride);
			jCheckBoxMercuryMake.setSelected(    MainOptionsPanel.mercuryMakeOverride);

			if (waitUpdate)
				waitUpdate = false;
		}
	}}

	private void updateElementsLater ()
	{
		synchronized (updateLock) {

		waitUpdate = true;
		Runnable doUpdate = new Runnable() {
			@Override
			public void run() {
				updateElements(false);
			}
		};

		SwingUtilities.invokeLater(doUpdate); // execute async on the AWT event dispatching thread
		//Thread t = new Thread(doUpdate);
		//t.start();
	}}

	// enable/disable input elements on value change
	private void enableElements ()
	{
		synchronized (updateLock) {

		jTextFieldMercuryCompiler.setEnabled(MainOptionsPanel.mercuryCompilerOverride);
		jTextFieldMercuryMake.setEnabled(MainOptionsPanel.mercuryMakeOverride);
		//jTextFieldBinsPath.setComponentPopupMenu(null); // XXX TODO disable menu when field disabled
	}}

	// set default values (if needed)
	// must be in sync with updatePrefs prefs.get default values !!!
	private void setElementsDefaults ()
	{
		synchronized (updateLock) {

		if (waitUpdate)
			return; // see updateElements

		boolean update = false;

		// check for default values
		if (!MainOptionsPanel.mercuryCompilerOverride &&
			!MainOptionsPanel.mercuryCompiler.equals(MainOptionsPanel.MERCURY_MMC_DEFAULT_CMD))
		{
			MainOptionsPanel.mercuryCompiler = MainOptionsPanel.MERCURY_MMC_DEFAULT_CMD;
			update = true;
		}
		if (!MainOptionsPanel.mercuryMakeOverride &&
			!MainOptionsPanel.mercuryMake.equals(MainOptionsPanel.MERCURY_MMAKE_DEFAULT_CMD))
		{
			MainOptionsPanel.mercuryMake = MainOptionsPanel.MERCURY_MMAKE_DEFAULT_CMD;
			update = true;
		}

		if (update)
			updateElementsLater();
	}}

	//
	private void checkSettings ()
	{
		if (MainOptionsPanel.mercuryBinPath.isEmpty())
			return;

		File binDir = new File(MainOptionsPanel.mercuryBinPath);
		File libDir = new File(MainOptionsPanel.mercuryLibPath);

		if (binDir.isDirectory() && binDir.canRead() &&
				libDir.isDirectory() && libDir.canRead())
			{ }
		else
		{
			String msg = "Invalid Mercury install path '" + getMercuryPath() + "'";
			MercuryInterface.showMessage(msg, false);
		}
	}

	// -----------------------------------------------------------------

	// load/save prefs
	private static void updatePrefs (boolean save)
	{
		Preferences prefs = NbPreferences.forModule(MainOptionsPanel.class);

		// XXX TODO store only modified settings
		//
		// Example:
		// Preferences.userNodeForPackage(MainOptionsPanel.class).putBoolean("someFlag", someCheckBox.isSelected());
		// or for org.openide.util with API spec. version >= 7.4:
		// NbPreferences.forModule(MainOptionsPanel.class).putBoolean("someFlag", someCheckBox.isSelected());
		// or:
		// SomeSystemOption.getDefault().setSomeStringProperty(someTextField.getText());

		final String version = "01a";
		if (save)
		{
			prefs.put("mercuryPath_v" + version,       MainOptionsPanel.mercuryPath);
			prefs.put("mercuryCompiler_v" + version,   MainOptionsPanel.mercuryCompiler);
			prefs.put("mercuryMake_v" + version,       MainOptionsPanel.mercuryMake);
			prefs.put("additionalExecute_v" + version, MainOptionsPanel.additionalExecute);
			prefs.put("binsPath_v" + version,          MainOptionsPanel.binsPath);

			prefs.putBoolean("mercuryCompilerOverride_v" + version, MainOptionsPanel.mercuryCompilerOverride);
			prefs.putBoolean("mercuryMakeOverride_v" + version,     MainOptionsPanel.mercuryMakeOverride);
		}
		else
		{
			MainOptionsPanel.mercuryPath       = prefs.get("mercuryPath_v" + version,       "").trim();
			MainOptionsPanel.mercuryCompiler   = prefs.get("mercuryCompiler_v" + version,   MainOptionsPanel.MERCURY_MMC_DEFAULT_CMD).trim();
			MainOptionsPanel.mercuryMake       = prefs.get("mercuryMake_v" + version,       MainOptionsPanel.MERCURY_MMAKE_DEFAULT_CMD).trim();
			MainOptionsPanel.additionalExecute = prefs.get("additionalExecute_v" + version, "").trim();
			MainOptionsPanel.binsPath          = prefs.get("binsPath_v" + version,          "").trim();

			MainOptionsPanel.mercuryCompilerOverride = prefs.getBoolean("mercuryCompilerOverride_v" + version, false);
			MainOptionsPanel.mercuryMakeOverride     = prefs.getBoolean("mercuryMakeOverride_v" + version,     false);

			//MainOptionsPanel.mercuryCompiler = MERCURY_MMC_NIX_CMD;
			//MainOptionsPanel.mercuryMake = MERCURY_MMAKE_NIX_CMD;
		}
	}

	//
	private static void updateSettings ()
	{
		// change settings only on prefs update (after Ok/Apply/Cancel clicked at panel)
		// XXX TODO add lock (can run and change options on compilation!!!)
		if (!MainOptionsPanel.prefsUpdated)
			return;
		MainOptionsPanel.prefsUpdated = false;

		updatePrefs(false); // load stored prefs

		final String path = getMercuryPath();
		if (path.isEmpty())
		{
			// reset subdirs settings if mercury path is empty
			MainOptionsPanel.mercuryBinPath = "";
			MainOptionsPanel.mercuryLibPath = "";
		}
		else
		{
			MainOptionsPanel.mercuryBinPath = path + MainOptionsPanel.MERCURY_BIN_SUBDIR;
			MainOptionsPanel.mercuryLibPath = path + MainOptionsPanel.MERCURY_LIB_SUBDIR;
		}
	}

	// public functions to get settings
	// XXX TODO may be add proxy funcs to MercuryInterface (see initCompletionLibrary())?

	public static String getMercuryCompilerCmd ()
	{
		updateSettings();
		return MainOptionsPanel.mercuryCompiler;
	}

	public static String getMercuryMakeCmd ()
	{
		updateSettings();
		return MainOptionsPanel.mercuryMake;
	}

	public static String getMercuryPath ()
	{
		updateSettings();

		// may be return without / at end?
		// may be use FileUtil.normalizeFile ?
		if (MainOptionsPanel.mercuryPath.isEmpty())
			return "";
		return CompilerHelper.pathAddSeparator(MainOptionsPanel.mercuryPath);
	}
/*
	public static String getMercuryLibPath ()
	{
		updateSettings();

		if (MainOptionsPanel.mercuryLibPath.isEmpty())
			return "";
		return CompilerHelper.pathAddSeparator(MainOptionsPanel.mercuryLibPath);
	}
*/
	public static String getAdditionalExecuteCmd ()
	{
		updateSettings();

		// XXX TODO check if path already with "
		String path = MainOptionsPanel.additionalExecute;
		if (path.indexOf(' ') != -1 && (new File(path)).isFile())
			path = "\"" + path + "\"";
		return path;
	}

	public static String getBinsPath ()
	{
		updateSettings();

		String path = MainOptionsPanel.mercuryBinPath;
		if (!MainOptionsPanel.binsPath.isEmpty())
		{
			if (!path.isEmpty())
				path += File.pathSeparator;
			path += MainOptionsPanel.binsPath;
		}
		return path;
	}
}
