
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.global;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.mercury.compiler.Compiler;
import org.mercury.compiler.CompilerHelper;
import org.mercury.lang.MercuryCompletionItem;
import org.mercury.lang.NBS;
import org.mercury.lang.ParserHelper;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

// access to this class:
// import org.openide.util.Lookup;
// MercuryInterface glb = Lookup.getDefault().lookup(MercuryInterface.class);

public class MercuryInterface {

	public static final RequestProcessor THREAD_POOL =
							new RequestProcessor("MercuryLang processor", 1);

	// XXX TODO fix this
	public static final AtomicBoolean compiler_lock = new AtomicBoolean(false);
	public static RequestProcessor.Task compiler_task;

	// run compiler in separate task on DataObject (file)
	public static boolean RunCompilerTask (DataObject dObj, boolean useMmake)
	{
		if (!compiler_lock.compareAndSet(false, true))
			return false;

		Runnable compiler = new Compiler(dObj, useMmake);
		compiler_task = THREAD_POOL.post(compiler);

		return true;
	}

	// run compiler in separate task on Project
	public static boolean RunCompilerTask (Project pObj)
	{
		if (!compiler_lock.compareAndSet(false, true))
			return false;

		Runnable compiler = new Compiler(pObj);
		compiler_task = THREAD_POOL.post(compiler);

		return true;
	}

	// get modules list from project or dir containing document
	// sample result:
	// main /root/test/source/main.m
	// test /root/test/source/test.m
	// test2 /root/test/source/main.m
	public static Map<String, String> getModules (Document document)
	{
		DataObject dObj = NbEditorUtilities.getDataObject(document);
		if (dObj == null)
			return null;

		CompilerHelper compiler = new CompilerHelper(dObj);
		return compiler.getModules();
	}

	// tries to find file by path
	public static DataObject getFile (String filename)
	{
		CompilerHelper compiler = new CompilerHelper();

		DataObject file = compiler.getFile(filename);
		return file;
	}

	// create new mercury document from DataObject text file
	public static Document createDocument (DataObject dObj)
	{
		FileObject file = dObj.getPrimaryFile();
		return createDocument(file);
	}

	public static Document createDocument (FileObject file)
	{
		String text = null;

		try
		{
			if (file != null && file.isData())
				text = file.asText();
		}
		catch (IOException ex)
		{
			Exceptions.printStackTrace(ex);
		}

		if (text == null)
			return null;

		return createDocument(text);
	}

	public static Document createDocument (String text)
	{
		Document document = new BaseDocument(false, "text/x-mercury");
		try
		{
			document.insertString(0, text, null);
			return document;
		}
		catch (BadLocationException ex)
		{
			Exceptions.printStackTrace(ex);
		}

		return null;
	}

	// get an output window tab
	public static OutputWriter getOutputWindow ()
	{
		return getOutputWindow ("Mercury", true);
	}

	public static OutputWriter getOutputWindow (String name, boolean is_cleanup)
	{
		// get an output window tab
		InputOutput io = IOProvider.getDefault().getIO(name, false);
		io.select();
		OutputWriter outputWriter = io.getOut();

		if (!is_cleanup)
			return outputWriter;

		// cleanup output
		try
		{
			outputWriter.reset();
		}
		catch (IOException ex)
		{
			Exceptions.printStackTrace(ex);
		}

		return outputWriter;
	}

	//
	public static void initCompletionLibrary ()
	{
		NBS.initLibrary();
	}

	// parse document
	public static TokenSequence parseDocument (Document document)
	{
		((AbstractDocument) document).readLock();
		try
		{
			return ParserHelper.getTokenSequence(document);
		}
		finally
		{
			((AbstractDocument) document).readUnlock();
		}
	}

	// parse document and get completion items for token at offset
	public static List<MercuryCompletionItem> getCompletionItems (Document document,
																	int offset)
	{
		List<MercuryCompletionItem> items = NBS.completionItems(document, offset, true);
		return items;
	}

	// open file in editor at specified line
	public static boolean openEditor (String filePath, int offset, boolean isLineOffset,
										String statusText)
	{
		CompilerHelper compiler = new CompilerHelper();
		return compiler.openEditor(filePath, offset, isLineOffset, statusText);
	}

	public static boolean openEditor (Document document, int offset, boolean isLineOffset,
										String statusText)
	{
		DataObject dObj = NbEditorUtilities.getDataObject(document);
		if (dObj == null)
			return false;

		CompilerHelper compiler = new CompilerHelper(dObj);
		return compiler.openEditor(null, offset, isLineOffset, statusText);
	}

	//
	public static void showMessage (String str, boolean wait)
	{
		NotifyDescriptor.Message desc = new NotifyDescriptor.Message(str);
		if (wait)
			DialogDisplayer.getDefault().notify(desc);
		else
			DialogDisplayer.getDefault().notifyLater(desc);
	}
}
