
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.actions;

import org.mercury.MercuryDataObject;
import org.mercury.global.MercuryInterface;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class MakeProject extends CookieAction
{
	// try or not to build main project (if selected)
	public static final String BUILD_NOMAIN_PARAM = "noMainProject";

	protected void performAction (Node[] activatedNodes)
	{
		// get current project
		Project project = activatedNodes[0].getLookup().lookup(Project.class);
		MercuryDataObject mercuryDataObject = null;
		if (project == null)
		{
			mercuryDataObject = activatedNodes[0].getLookup().lookup(MercuryDataObject.class);
			project = FileOwnerQuery.getOwner(mercuryDataObject.getPrimaryFile());
		}

		// use main project if have and allowed (see MercuryProject.invokeAction)
		Object useMainPrj = this.getValue(MakeProject.BUILD_NOMAIN_PARAM);
		if (useMainPrj == null || useMainPrj.equals(false))
		{
			Project mainProject = OpenProjects.getDefault().getMainProject();
			if (mainProject != null)
				project = mainProject;
		}
		this.putValue(MakeProject.BUILD_NOMAIN_PARAM, null);

		// start compiler task
		// use project if we have opened project otherwise try to build current file with mmake cmd
		boolean result = true;
		if (project != null)
			result = MercuryInterface.RunCompilerTask(project);
		else if (mercuryDataObject != null)
			result = MercuryInterface.RunCompilerTask(mercuryDataObject, true);
		else
			MercuryInterface.showMessage("There is no opened project.", false);

		if (!result)
			MercuryInterface.showMessage("Compile task already running", false);
	}

	protected int mode ()
	{
		return CookieAction.MODE_EXACTLY_ONE;
	}

	public String getName ()
	{
		return NbBundle.getMessage(MakeProject.class, "CTL_MercuryMakeProject");
	}

	protected Class[] cookieClasses ()
	{
		return new Class[]{Project.class, MercuryDataObject.class};
	}

	@Override
	protected String iconResource ()
	{
		return "org/mercury/mercury.png";
	}

	public HelpCtx getHelpCtx ()
	{
		return HelpCtx.DEFAULT_HELP;
	}

	@Override
	protected boolean asynchronous () {
		return false;
	}
}
