package org.mercury.actions;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.mercury.global.MercuryInterface;
import org.mercury.lang.MercuryCompletionItem;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;

public class Hyperlink implements HyperlinkProviderExt {

	private int targetStart;
	private int targetEnd;

	private String filePath;
	private int offset;

	@Override
	public Set<HyperlinkType> getSupportedHyperlinkTypes ()
	{
		return Collections.singleton(HyperlinkType.GO_TO_DECLARATION);
	}

	@Override
	public boolean isHyperlinkPoint (Document document, int offset, HyperlinkType type)
	{
		List<MercuryCompletionItem> items = MercuryInterface.getCompletionItems(document, offset);

		String text = null;
		int len = document.getLength();
		if (len < 3 || len == offset)
			return false;

		// get identifier
		// XXX TODO rewrite this

		try { text = document.getText(0, document.getLength()); } catch (BadLocationException ex) { }
		if (text == null)
			return false;

		int s = offset;
		while (s >= 0 && isIdentifierChar(text.charAt(s))) s--;
		s++;
		while (s < len && text.charAt(s) == '.') s++;

		int e = offset;
		while (e < len && isIdentifierChar(text.charAt(e))) e++;
		while (e >= 0 && text.charAt(e) == '.') e--;

		if (e <= 0 || s == len || e < s)
			return false;

		String identifier = text.substring(s, e);
		if (identifier.isEmpty())
			return false;

		// check identifier name
		// XXX TODO slow, use hashmap

		Iterator<MercuryCompletionItem> it = items.iterator();
		while (it.hasNext())
		{
			MercuryCompletionItem complItem = it.next();
			if (complItem.getOffset() == 0 || !complItem.getText().equals(identifier))
				continue;

			// found!

			this.targetStart = s;
			this.targetEnd = e;

			this.filePath = complItem.getFilePath();
			this.offset = complItem.getOffset();

			return true;
		}

		return false;
	}

	// XXX TODO national names not accepted ('тест')
	private boolean isIdentifierChar (char c)
	{
		// see mercury.nbs identifier
		return (c == '_' || c == '.' || c == '\'' || (c >= '0' && c <= '9') ||
				(c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z'));
	}

	@Override
	public int[] getHyperlinkSpan (Document document, int offset, HyperlinkType type)
	{
		return new int[]{this.targetStart, this.targetEnd};
	}

	@Override
	public void performClickAction (Document document, int offset, HyperlinkType type)
	{
		if (filePath == null)
			MercuryInterface.openEditor(document, this.offset, false, null);
		else
			MercuryInterface.openEditor(filePath, this.offset, false, null);
	}

	@Override
	public String getTooltipText (Document document, int offset, HyperlinkType type)
	{
		return "";
	}
}
