
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.actions;

import org.mercury.MercuryDataObject;
import org.mercury.global.MercuryInterface;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class CompileFile extends CookieAction
{
	protected void performAction (Node[] activatedNodes)
	{
		MercuryDataObject mercuryDataObject =
			activatedNodes[0].getLookup().lookup(MercuryDataObject.class);

		// start compiler task
		if (!MercuryInterface.RunCompilerTask(mercuryDataObject, false))
			MercuryInterface.showMessage("Compile task already running", false);
	}

	protected int mode ()
	{
		return CookieAction.MODE_EXACTLY_ONE;
	}

	public String getName ()
	{
		return NbBundle.getMessage(CompileFile.class, "CTL_MercuryCompileFile");
	}

	protected Class[] cookieClasses ()
	{
		return new Class[]{MercuryDataObject.class};
	}

	@Override
	protected String iconResource ()
	{
		return "org/mercury/mercury.png";
	}

	public HelpCtx getHelpCtx ()
	{
		return HelpCtx.DEFAULT_HELP;
	}

	@Override
	protected boolean asynchronous ()
	{
		return false;
	}
}
