
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury;

import java.io.IOException;
import javax.swing.text.Document;
import org.mercury.global.MercuryInterface;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class MercuryDataObject extends MultiDataObject
{
	private static volatile boolean isFirst = true;
	private static final String mercurySrc =
							":- module main.\n" +
							":- interface.\n" +
							":- import_module io.\n\n" +
							":- pred main(io::di, io::uo) is det.\n\n" +
							":- implementation.\n\n" +
							"main(!IO) :-\n" +
							"   io.write_string(\"Works!\\n\", !IO).\n";

	public MercuryDataObject (FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException
	{
		super(pf, loader);

		CookieSet cookies = getCookieSet();
		cookies.add((Node.Cookie) DataEditorSupport.create(this, getPrimaryEntry(), cookies));

		//registerEditor("text/x-mercury", true);

		// NBS bug fix (reopened files not parsed when loading IDE)
		if (!MercuryDataObject.isFirst)
			return;
		MercuryDataObject.isFirst = false;

		try
		{
			Document doc = MercuryInterface.createDocument(MercuryDataObject.mercurySrc);
			Object r = (doc == null) ? null : (Object) MercuryInterface.parseDocument(doc);

			MercuryInterface.initCompletionLibrary();
		}
		catch (Exception ex)
		{
			Exceptions.printStackTrace(ex);
		}
	}

	@Override
	protected Node createNodeDelegate ()
	{
		return (new DataNode(this, Children.LEAF, getLookup()));
	}

	@Override
	public Lookup getLookup ()
	{
		Lookup lookup = getCookieSet().getLookup();
		return lookup;
	}

	@MultiViewElement.Registration(
		displayName = "#LBL_Mercury_source",
		iconBase = "org/mercury/mercury_ok.png",
		mimeType = "text/x-mercury",
		persistenceType = TopComponent.PERSISTENCE_ONLY_OPENED,
		preferredID = "mercury",
		position = 1000)
//	@Messages("LBL_Mercury_source=Source")
	public static MultiViewEditorElement createEditor (Lookup lkp)
	{
		return (new MultiViewEditorElement(lkp));
	}

	@Override
	protected int associateLookup ()
	{
		return 1;
	}
}
