
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.project.templates;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

// panel just asking for basic info
public class SimpleProjectWizardPanel implements WizardDescriptor.Panel,
	WizardDescriptor.ValidatingPanel, WizardDescriptor.FinishablePanel
{
	private WizardDescriptor wizardDescriptor;
	private SimpleProjectPanelVisual component;

	public SimpleProjectWizardPanel ()
	{
	}

	public Component getComponent ()
	{
		if (component == null)
		{
			component = new SimpleProjectPanelVisual(this);
			component.setName(NbBundle.getMessage(SimpleProjectWizardPanel.class,
													"LBL_CreateProjectStep"));
		}

		return component;
	}

	public HelpCtx getHelp ()
	{
		// XXX TODO fix this
		// http://netbeans.org/bugzilla/show_bug.cgi?id=200499

		return new HelpCtx(SimpleProjectWizardPanel.class.getName());
		//return new HelpCtx(SimpleProjectWizardPanel.class);
	}

	public boolean isValid ()
	{
		getComponent();
		return component.valid(wizardDescriptor);
	}

	// or can use ChangeSupport in NB 6.0
	private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

	public final void addChangeListener (ChangeListener l)
	{
		synchronized (listeners)
		{
			listeners.add(l);
		}
	}

	public final void removeChangeListener (ChangeListener l)
	{
		synchronized (listeners)
		{
			listeners.remove(l);
		}
	}

	protected final void fireChangeEvent ()
	{
		Set<ChangeListener> ls;
		synchronized (listeners)
		{
			ls = new HashSet<ChangeListener>(listeners);
		}

		ChangeEvent ev = new ChangeEvent(this);
		for (ChangeListener l : ls)
			l.stateChanged(ev);
	}

	public void readSettings (Object settings)
	{
		wizardDescriptor = (WizardDescriptor) settings;
		component.read(wizardDescriptor);
	}

	public void storeSettings (Object settings)
	{
		WizardDescriptor d = (WizardDescriptor) settings;
		component.store(d);
	}

	public boolean isFinishPanel ()
	{
		return true;
	}

	public void validate () throws WizardValidationException
	{
		getComponent();
		component.validate(wizardDescriptor);
	}
}
