
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.project;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class MercuryProjectLogicalView implements LogicalViewProvider
{
	private final MercuryProject project;

	public MercuryProjectLogicalView (MercuryProject project)
	{
		this.project = project;
	}

	@Override
	public org.openide.nodes.Node createLogicalView ()
	{
		try
		{
			// get the Source directory, creating if deleted
			FileObject source = project.getSourceFolder(true);

			// get the DataObject that represents it
			DataFolder textDataObject = DataFolder.findFolder(source);

			// get its default node-we'll wrap our node around it to change the
			// display name, icon, etc
			Node realTextFolderNode = textDataObject.getNodeDelegate();

			// this FilterNode will be our project node
			return new TextNode(realTextFolderNode, project);
		}
		catch (DataObjectNotFoundException donfe)
		{
			Exceptions.printStackTrace(donfe);

			// fallback-the directory couldn't be created -
			// read-only filesystem or something evil happened
			return new AbstractNode(Children.LEAF);
		}
	}

	// this is the node you actually see in the project tab for the project
	private static final class TextNode extends FilterNode
	{
		final MercuryProject project;

		public TextNode (Node node, MercuryProject project) throws DataObjectNotFoundException
		{
			super(node, new FilterNode.Children(node),
					// the projects system wants the project in the Node's lookup.
					// NewAction and friends want the original Node's lookup.
					// make a merge of both
					new ProxyLookup(new Lookup[] {Lookups.singleton(project),
													node.getLookup()})
				);

			this.project = project;
		}

		// project popup menu actions
		@Override
		public Action[] getActions (boolean arg0)
		{
			String sBuildProject =
					NbBundle.getMessage(MercuryProjectLogicalView.class, "CTL_MercuryBuildProject");
			//Action buildAction =
			//		ProjectSensitiveActions.projectCommandAction(ActionProvider.COMMAND_BUILD,
			//														sBuildProject, null);
			Action buildAction =
					ProjectSensitiveActions.projectCommandAction(MercuryProject.COMMAND_BUILD_SELECTED,
																	sBuildProject, null);

			Action[] nodeActions = new Action[7];
			nodeActions[0] = CommonProjectActions.newFileAction();
			nodeActions[1] = buildAction;
			nodeActions[2] = CommonProjectActions.copyProjectAction();
			nodeActions[3] = CommonProjectActions.deleteProjectAction();
			nodeActions[5] = CommonProjectActions.setAsMainProjectAction();
			nodeActions[6] = CommonProjectActions.closeProjectAction();

			return nodeActions;
		}

		@Override
		public Image getIcon (int type)
		{
			return ImageUtilities.loadImage("org/mercury/project/mercury.png");
		}

		@Override
		public Image getOpenedIcon (int type)
		{
			return getIcon(type);
		}

		@Override
		public String getDisplayName ()
		{
			return project.getProjectDirectory().getName();
		}
	}

	@Override
	public Node findPath (Node root, Object target)
	{
		// leave unimplemented for now
		return null;
	}
}
