
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.project;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileObject;

@org.openide.util.lookup.ServiceProvider(service=ProjectFactory.class)
public class MercuryProjectFactory implements ProjectFactory
{
	// XXX TODO sync this with org.mercury.compiler.CompilerHelper
	public static final String PROJECT_DIR    = "mercury";
	public static final String PROJECT_FILE   = "Mercury.project";
	public static final String PROJECT_SRCDIR = "source";

	// specifies when a project is a project, i.e.,
	// if the project directory "mercury" is present
	// and file Mercury.modules is present
	@Override
	public boolean isProject (FileObject projectDirectory)
	{
		FileObject project_dir = projectDirectory.getFileObject(MercuryProjectFactory.PROJECT_DIR);
		if (project_dir == null || !project_dir.isFolder())
			return false;

		FileObject project_file = project_dir.getFileObject(MercuryProjectFactory.PROJECT_FILE);
		if (project_file == null || !project_file.isData())
			return false;

		return true;
	}

	// specifies when the project will be opened, i.e.,
	// if the project exists
	@Override
	public Project loadProject (FileObject dir, ProjectState state) throws IOException
	{
		return (Project) (isProject(dir) ? new MercuryProject(dir, state) : null);
	}

	@Override
	public void saveProject (final Project project) throws IOException, ClassCastException
	{
		FileObject projectRoot = project.getProjectDirectory();
		if (projectRoot.getFileObject(MercuryProjectFactory.PROJECT_SRCDIR) == null)
		{
			throw new IOException("Source dir '" + projectRoot.getPath() +
									"' deleted, cannot save project");
		}

		// force creation of the sources dir if it was deleted
		((MercuryProject) project).getSourceFolder(true);
	}
}
