
/**
 *
 * @author gloom@opcode.cc 2017
 */

package org.mercury.project;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.CookieAction;
import org.openide.util.lookup.Lookups;

public class MercuryProject implements Project
{
	// XXX TODO sync this with org.mercury layer.xml
	public static final String MERCURY_BUILD_ACTION   = "Actions/Build/org-mercury-actions-MakeProject.instance";
	public static final String MERCURY_COMPILE_ACTION = "Actions/Build/org-mercury-actions-CompileFile.instance";

	// XXX TODO sync this with org.mercury.actions.MakeProject
	public static final String BUILD_NOMAIN_PARAM = "noMainProject";

	public static final String COMMAND_BUILD_SELECTED = "mercury.build.selected";

	private final FileObject projectDir;
	private final ProjectState state;
	private Lookup lkp;

	public MercuryProject (FileObject projectDir, ProjectState state)
	{
		this.projectDir = projectDir;
		this.state = state;
	}

	@Override
	public FileObject getProjectDirectory ()
	{
		return projectDir;
	}

	FileObject getSourceFolder (boolean create)
	{
		FileObject result = projectDir.getFileObject(MercuryProjectFactory.PROJECT_SRCDIR);
		if (result == null && create)
		{
			try
			{
				result = projectDir.createFolder(MercuryProjectFactory.PROJECT_SRCDIR);
			}
			catch (IOException ioe)
			{
				Exceptions.printStackTrace(ioe);
			}
		}

		return result;
	}

	// the project type's capabilities are registered in the project's lookup
	@Override
	public Lookup getLookup ()
	{
		if (lkp == null)
		{
			lkp = Lookups.fixed(new Object[]{
						state,                               // allow outside code to mark the project as needing saving
						new ActionProviderImpl(),            // standard actions like Build and Clean
						new MercuryDeleteOperation(),
						new MercuryCopyOperation(this),
						new Info(),                          // project information implementation
						new MercuryProjectLogicalView(this), // logical view of project implementation
					});
		}

		return lkp;
	}

	private final class ActionProviderImpl implements ActionProvider
	{
		final private String[] supported =
				new String[] {
					ActionProvider.COMMAND_DELETE,
					ActionProvider.COMMAND_COPY,
					ActionProvider.COMMAND_BUILD,
					ActionProvider.COMMAND_COMPILE_SINGLE,
					MercuryProject.COMMAND_BUILD_SELECTED // build selected project (from project popup menu)
				};

		@Override
		public String[] getSupportedActions ()
		{
			return supported;
		}

		@Override
		public void invokeAction (String string, Lookup lookup) throws IllegalArgumentException
		{
			if (string.equalsIgnoreCase(ActionProvider.COMMAND_DELETE))
				DefaultProjectOperations.performDefaultDeleteOperation(MercuryProject.this);

			else if (string.equalsIgnoreCase(ActionProvider.COMMAND_COPY))
				DefaultProjectOperations.performDefaultCopyOperation(MercuryProject.this);

			else if (string.equalsIgnoreCase(ActionProvider.COMMAND_BUILD) ||
						string.equals(MercuryProject.COMMAND_BUILD_SELECTED))
			{
				CookieAction action =
						FileUtil.getConfigObject(MercuryProject.MERCURY_BUILD_ACTION, CookieAction.class);
				if (action != null)
				{
					//Info i = new Info();
					action.putValue(MercuryProject.BUILD_NOMAIN_PARAM,
									string.equals(MercuryProject.COMMAND_BUILD_SELECTED));
					action.actionPerformed(null);
				}
			}

			// XXX TODO move to MercurySupport
			else if (string.equalsIgnoreCase(ActionProvider.COMMAND_COMPILE_SINGLE))
			{
				CookieAction action =
						FileUtil.getConfigObject(MercuryProject.MERCURY_COMPILE_ACTION, CookieAction.class);
				if (action != null)
					action.actionPerformed(null);
			}
		}

		@Override
		public boolean isActionEnabled (String command, Lookup lookup) throws IllegalArgumentException
		{
			if ((command.equalsIgnoreCase(ActionProvider.COMMAND_DELETE)))
				return true;

			else if ((command.equalsIgnoreCase(ActionProvider.COMMAND_COPY)))
				return true;

			else if ((command.equalsIgnoreCase(ActionProvider.COMMAND_BUILD)))
				return true;

			else if ((command.equalsIgnoreCase(ActionProvider.COMMAND_COMPILE_SINGLE)))
				return true;

			else if ((command.equals(MercuryProject.COMMAND_BUILD_SELECTED)))
				return true;

			else
				throw new IllegalArgumentException(command);
		}
	}

	private final class MercuryDeleteOperation implements DeleteOperationImplementation
	{
		public void notifyDeleting () throws IOException
		{
		}

		public void notifyDeleted () throws IOException
		{
		}

		public List<FileObject> getMetadataFiles ()
		{
			List<FileObject> dataFiles = new ArrayList<FileObject>();
			return dataFiles;
		}

		public List<FileObject> getDataFiles ()
		{
			List<FileObject> dataFiles = new ArrayList<FileObject>();
			return dataFiles;
		}
	}

	private final class MercuryCopyOperation implements CopyOperationImplementation
	{
		//private final MercuryProject project;
		//private final FileObject projectDir;

		public MercuryCopyOperation (MercuryProject project)
		{
			//this.project = project;
			//this.projectDir = project.getProjectDirectory();
		}

		public List<FileObject> getMetadataFiles ()
		{
			List<FileObject> retVal = Collections.emptyList();
			return retVal;
		}

		public List<FileObject> getDataFiles ()
		{
			List<FileObject> retVal = Collections.emptyList();
			return retVal;
		}

		public void notifyCopying () throws IOException
		{
		}

		public void notifyCopied (Project arg0, File arg1, String arg2) throws IOException
		{
		}
	}

	private final class Info implements ProjectInformation
	{
		@Override
		public Icon getIcon ()
		{
			return new ImageIcon(ImageUtilities.loadImage("org/mercury/project/mercury.png"));
		}

		@Override
		public String getName ()
		{
			return getProjectDirectory().getName();
		}

		@Override
		public String getDisplayName ()
		{
			return getName();
		}

		@Override
		public void addPropertyChangeListener (PropertyChangeListener pcl)
		{
			// do nothing, won't change
		}

		@Override
		public void removePropertyChangeListener (PropertyChangeListener pcl)
		{
			// do nothing, won't change
		}

		@Override
		public Project getProject ()
		{
			return MercuryProject.this;
		}
	}
}
